/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CPropertySheet.h,v 1.3 1999/12/22 10:05:04 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CPropertySheet_h	// [
#define Included_CPropertySheet_h

#include "pgpClassesConfig.h"
#include <prsht.h>

#include "CArray.h"
#include "CList.h"

_PGP_BEGIN

// Types

class CPropertyPage;


// Class CPropertySheet

class CPropertySheet
{
	NOT_COPYABLE(CPropertySheet)

public:
	CPropertySheet();
	~CPropertySheet();

	void	AddPage(CPropertyPage *pPage);
	void	RemovePage(CPropertyPage *pPage);
	void	ClearPages();

	virtual void	Create(HWND parent, PGPBoolean isWizard = FALSE);

protected:
	PROPSHEETHEADER	mPSH;

	virtual void	PreCreateHook() { }

private:
	CList<CWindow>			mPageList;
	CArray<HPROPSHEETPAGE>	mPageArray;
	PGPUInt32				mNumPages;

	CComboError	mError;
	PGPBoolean	mSkipConfirmCancel;
};

_PGP_END

#endif	// ] Included_CPropertySheet_h
